<?php

if(!empty($PdfData->HeaderPool)) {
	require_once(PdfChunkLoader('OrisElimStartList.inc.php'));
} else {

	$pdf->ShotOffShort=$PdfData->ShotOffShort;
	$pdf->CoinTossShort=$PdfData->CoinTossShort;

	if(count($PdfData->rankData['sections'])) {
		$DistSize = 15;
		$AddSize=0;
		$pdf->setDocUpdate($PdfData->rankData['meta']['lastUpdate']);
		$First=true;

		foreach($PdfData->rankData['sections'] as $section) {
			$arrTitles=array("Rank","Back No.#", "Name", "NOC", "Elimination#","@" . $section['meta']['fields']['gold'] . "'s#","@" . $section['meta']['fields']['xnine'] . "'s#");
			$arrSizes=array(15,15,60,20,array(15,5),10,10);
			if($section['meta']['running'])
				$arrTitles[] = "No. of\nArrows#";
			else
				$arrTitles[] = "Score#";
			$arrSizes[] = 20;

			if($section['meta']['running']) {
				$arrTitles[] = "Arrow\nAverage#";
				$arrSizes[] = 15;
			}
			$arrTitles[] = "";
			$arrSizes[] = ($section['meta']['running'] ? 5 : 10);

			$pdf->SetDataHeader($arrTitles, $arrSizes);

			$pdf->setEvent($section['meta']['descr']);

			if($section['meta']['roundText'] == 'Eliminations_1') {
				$Phase=' ('. $section['meta']['round'] . ')';
				$pdf->setPhase("Elimination Round 1");
			} elseif($section['meta']['roundText'] == 'Eliminations_2') {
				$Phase=' ('. $section['meta']['round'] . ')';
				$pdf->setPhase("Elimination Round 2");
			} else {
				$Phase='';
				$pdf->setPhase("Elimination Round");
			}

				// Gestione del commento di Stampa
	//			if (!is_null($MyRow->EvQualPrintHead) && $MyRow->EvQualPrintHead!='')
	//				$pdf->setComment($MyRow->EvQualPrintHead);

			$pdf->setOrisCode('C73A', ($section['meta']['running']  ? 'Running ' : '') . 'Results');
			$pdf->AddPage();
			if($First and (empty($pdf->CompleteBookTitle) or $pdf->CompleteBookTitle!=$PdfData->IndexName)) {
				$pdf->Bookmark($PdfData->IndexName, 0);
				$pdf->CompleteBookTitle=$PdfData->IndexName;
			}
			$First=false;
			$pdf->Bookmark($section['meta']['descr'] . $Phase, 1);

			$EndQualified = false;
			foreach($section['items'] as $item) {
				if($EndQualified===false && $item['rank']>$section['meta']['qualifiedNo']) {
					$pdf->addSpacer();
					$EndQualified = true;
				}
				$dataRow = array(
					$item['showRank']? $item['rank'] : $item['irmText'],
					$item['target'] . " #",
					$item['athlete'],
					$item['countryCode'],
					$item['completeScore'] . "#",
					"/" . str_pad($item['rank'],2," ", STR_PAD_LEFT) . "#",
					$item['gold'] . "#",
					$item['xnine'] . "#",
					);

				if($section['meta']['running']) {
					$dataRow[] = $item['hits'] . "#";
				}
				$dataRow[] = $item['score'] . "#";

				if($section['meta']['running']) {
					$dataRow[] = '';
				} else {
					if($item['so']>0) { //Spareggio
						$dataRow[] = $pdf->ShotOffShort;
                        if(strlen(trim($item['tiebreak']))) {
                            $dataRow[] = 'T.'.$item['tiebreakDecoded'];
                        }
					}
					elseif($item['ct']>1) {
						$dataRow[] = $pdf->CoinTossShort;
					} else {
						$dataRow[] = '';
					}
				}

				$pdf->printDataRow($dataRow);
			}
		}
	}
}


